using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
	   private static CPDF m_PDF;

      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      static bool Optimize(String InFile, String OutFile)
      {
         int retval;
         m_PDF.CreateNewPDF(null);                         // The output file will be created later
         m_PDF.SetDocInfo(TDocumentInfo.diProducer, null); // No need to override the original producer

         // The flag ifImportAsPage makes sure that pages will not be converted to templates.
         // We don't import a piece info dictionary here since this dictionary contains private data that
         // is only usable in the application that created the data. InDesign, for example, stores original
         // images and document files in this dictionary, if external resources were placed on a page.
         m_PDF.SetImportFlags((TImportFlags.ifImportAll | TImportFlags.ifImportAsPage) & ~TImportFlags.ifPieceInfo);
         // The flag if2UseProxy reduces the memory usage. The duplicate check is optional but recommended.
         // The resource name check can be omitted when we optimize a PDF file.
         m_PDF.SetImportFlags2(TImportFlags2.if2UseProxy | TImportFlags2.if2DuplicateCheck | TImportFlags2.if2NoResNameCheck);

         if ((retval = m_PDF.OpenImportFile(InFile, TPwdType.ptOpen, null)) < 0)
         {
            if (m_PDF.IsWrongPwd(retval))
            {
               Console.Write("PDFError File is encrypted!");
            }
            m_PDF.FreePDF();
            return false;
         }

         m_PDF.ImportPDFFile(1, 1.0, 1.0);
         m_PDF.CloseImportFile();

         // It is not allowed to call this function twice for the same document in memory!
         // In addition, we can either optimize the entire PDF file or nothing.
         m_PDF.Optimize(TOptimizeFlags.ofInMemory | TOptimizeFlags.ofNewLinkNames | TOptimizeFlags.ofDeleteInvPaths, null);
         // No fatal error occurred?
         if (m_PDF.HaveOpenDoc())
         {
            if (!m_PDF.OpenOutputFile(OutFile))
            {
               m_PDF.FreePDF();
               return false;
            }
            m_PDF.CloseFile();
            return true;
         }
         return false;
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            m_PDF = new CPDF();
            m_PDF.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            // Set the license key here if you have one
            // m_PDF.SetLicenseKey("");

            // Non embedded CID fonts depend usually on the availability of external cmaps.
            // So, external cmaps should be loaded if possible.
            m_PDF.SetCMapDir(Path.GetFullPath("../../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed | TLoadCMapFlags.lcmRecursive);

            String outFile = Directory.GetCurrentDirectory() + "/out.pdf";

            if (Optimize("../../../../dynapdf_help.pdf", outFile))
            {
               Console.Write("PDF file \"{0}\" successfully created!\n", outFile);
               System.Diagnostics.Process p = new System.Diagnostics.Process();
               p.StartInfo.FileName = outFile;
               p.Start();
            }
            m_PDF = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
